﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text.RegularExpressions;
using System.Web.Security.AntiXss;
using VIRP_WEB.BaseCode;
using VIRP_WEB.Controls.Custom.EFR;
using VIRP.EFR.BLL;
using VIRP.EFR.DAL;

namespace VIRP_WEB.Custom.EFR
{
    public partial class DoDFragmentAnalyte : EfrBasePage
    {
        private DoDFragmentDB manager = new DoDFragmentDB();
        protected readonly string DoDFragmentPage = "~/Custom/EFR/DoDFragment/DoDFragment.aspx?patientId=";
        protected override void Page_Load(object sender, EventArgs e)
        {
            LoadBaseControls();

            if (!IsPostBack)
            {
                HiddenFieldPatientID.Value = BaseCode.Helpers.AntiXssEval(Request.QueryString["patientId"]);
                HiddenFieldAnalyteID.Value = BaseCode.Helpers.AntiXssEval(Request.QueryString["dodFragmentAnalyteId"]);
                HiddenFieldFragmentID.Value = BaseCode.Helpers.AntiXssEval(Request.QueryString["dodFragmentId"]);

                string pageMode = "Add Analyte Data";

                if (!string.IsNullOrEmpty(HiddenFieldAnalyteID.Value)
                && HiddenFieldAnalyteID.Value != "0")
                    pageMode = "Edit Analyte Data";

                ReplacePageTitle("Patients > Patient Lookup > Workflows > DoD Fragment Data > " + pageMode);
            }
        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            LoadControlsFromObject();
        }        

        private void LoadBaseControls()
        {
            CommonManager commonManager = new CommonManager();
            List<STD_GUI_CONTROL> controls = commonManager.GetStdGuiControlsByCategory("DOD_FRAGMENT_ANALYTE_DATA_ENTRY", UserSession.CurrentRegistryId);

            foreach (STD_GUI_CONTROL dbItem in controls)
            {
                Control userControl = null;

                if (dbItem.BASE_CONTROL_TYPE == (int)EfrBaseControlType.TextBox)
                {
                    userControl = PanelAnalyte.FindControl(dbItem.USER_CONTROL_ID);
                    if (userControl != null)
                    {
                        BaseControlTextBox baseControl = (BaseControlTextBox)userControl;
                        baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH);
                    }
                }
                else if (dbItem.BASE_CONTROL_TYPE == (int)EfrBaseControlType.DropDownList)
                {
                    userControl = PanelAnalyte.FindControl(dbItem.USER_CONTROL_ID);
                    if (userControl != null)
                    {
                        BaseControlDropDownList baseControl = (BaseControlDropDownList)userControl;
                        baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY);
                        if (dbItem.USER_CONTROL_ID == "BaseControlDropdownListAnalyte")
                        {
                            baseControl.SetValueAsText();
                        }
                    }
                }
            }
        }

        protected void ButtonBack_Click(object sender, EventArgs e)
        {
            //Response.Redirect(String.Format("DoDFragment.aspx?patientId={0}", GetQueryStringValue(HiddenFieldPatientID.Value)));  
            ResponseRedirect(DoDFragmentPage, GetQueryStringValue(HiddenFieldPatientID.Value));
        }

        private string GetQueryStringValue(string patientID)
        {
            string vldPatientId = string.Empty;
            try
            {
                if (IsQueryStringValid(patientID))
                {
                    vldPatientId = patientID.ToString();
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError("Error parsing request data.: " + ex.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            }

            return vldPatientId;
        }

        private bool IsQueryStringValid(string patientID)
        {
            bool isStringValid = false;
            if (patientID != null)
            {
                if (Regex.IsMatch(patientID.ToString(), "^[a-zA-Z0-9]*$"))
                {
                    isStringValid = true;
                }
            }
            return isStringValid;
        }
        protected void ButtonSave_Click(object sender, EventArgs e)
        {
            DOD_FRAGMENT_DETAIL analyte = LoadObjectFromControls();
            //analyte = manager.Update(analyte);
            HiddenFieldAnalyteID.Value = analyte.DOD_FRAGMENT_DETAIL_ID.ToString();

            VIRP.EFR.BO.DOD_FRAGMENT_DETAIL analyteDb = new VIRP.EFR.BO.DOD_FRAGMENT_DETAIL();
            analyteDb.ANALYSIS_METHOD = analyte.ANALYSIS_METHOD;
            analyteDb.ANALYTE = analyte.ANALYTE;
            analyteDb.CAS_NUMBER = analyte.CAS_NUMBER;
            analyteDb.COMMENTS = analyte.COMMENTS;
            analyteDb.DOD_FRAGMENT_DETAIL_ID = analyte.DOD_FRAGMENT_DETAIL_ID;
            analyteDb.DOD_FRAGMENT_ID = analyte.DOD_FRAGMENT_ID;
            analyteDb.OTHER_ANALYSIS_METHOD = analyte.OTHER_ANALYSIS_METHOD;
            analyteDb.OTHER_ANALYTE = analyte.OTHER_ANALYTE;
            analyteDb.RESULT = analyte.RESULT;
            if (analyte.STD_FRAGMENT_ANALYSIS_TYPE != null)
                analyteDb.STD_FRAGMENT_ANALYSIS_TYPE_ID = analyte.STD_FRAGMENT_ANALYSIS_TYPE.ID;
            analyteDb.CREATED = analyteDb.UPDATED = DateTime.Now;
            analyteDb.CREATEDBY = analyteDb.UPDATEDBY = HttpContext.Current.User.Identity.Name;

            DOD_FRAGMENT_DETAILManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, analyteDb);

            // Response.Redirect(String.Format("DoDFragment.aspx?patientId={0}", GetQueryStringValue(HiddenFieldPatientID.Value)));
            ResponseRedirect(DoDFragmentPage, GetQueryStringValue(HiddenFieldPatientID.Value));
        }

        private DOD_FRAGMENT_DETAIL LoadObjectFromControls()
        {
            DOD_FRAGMENT_DETAIL analyte = new DOD_FRAGMENT_DETAIL();

            if (!string.IsNullOrEmpty(HiddenFieldAnalyteID.Value)
                && HiddenFieldAnalyteID.Value != "0")
            {
                analyte = manager.GetFragmentAnalyteById(Helpers.GetIntFromString(HiddenFieldAnalyteID.Value));
                //analyte.SetAsChangeTrackingRoot(false);
                //analyte.SetAsUpdateOnSubmit();
            }
            else
            {
                //analyte.SetAsChangeTrackingRoot();
                //analyte.SetAsInsertOnSubmit();
                analyte.DOD_FRAGMENT_ID = Helpers.GetIntFromString(HiddenFieldFragmentID.Value);
            }

            analyte.ANALYTE = BaseControlDropdownListAnalyte.Text;
            analyte.ANALYSIS_METHOD = BaseControlTextBoxAnalysisMethod.Text;
            analyte.OTHER_ANALYTE = BaseControlTextBoxOtherAnalyte.Text;
            if (Helpers.GetIntFromString(BaseControlDropDownListAnalysisType.Text) > 0)
            {
                if (analyte.STD_FRAGMENT_ANALYSIS_TYPE != null)
                {
                    analyte.STD_FRAGMENT_ANALYSIS_TYPE.ID = Helpers.GetIntFromString(BaseControlDropDownListAnalysisType.Text);
                }
                else
                {
                    analyte.STD_FRAGMENT_ANALYSIS_TYPE = new STD_FRAGMENT_ANALYSIS_TYPE();
                    analyte.STD_FRAGMENT_ANALYSIS_TYPE.ID = Helpers.GetIntFromString(BaseControlDropDownListAnalysisType.Text);
                }
            }
            else
            {
                analyte.STD_FRAGMENT_ANALYSIS_TYPE = null;
            }
            analyte.CAS_NUMBER = BaseControlTextBoxCasNumber.Text;
            analyte.RESULT = BaseControlTextBoxResult.Text;
            analyte.COMMENTS = BaseControlTextBoxComments.Text;

            return analyte;
        }
        
        private void LoadControlsFromObject()
        {
            if (!string.IsNullOrEmpty(HiddenFieldAnalyteID.Value)
                && HiddenFieldAnalyteID.Value != "0")
            {
                DOD_FRAGMENT_DETAIL analyte = manager.GetFragmentAnalyteById(Helpers.GetIntFromString(HiddenFieldAnalyteID.Value));
                BaseControlDropdownListAnalyte.Text = analyte.ANALYTE;
                BaseControlTextBoxAnalysisMethod.Text = analyte.ANALYSIS_METHOD;
                BaseControlTextBoxOtherAnalyte.Text = analyte.OTHER_ANALYTE;
                if (analyte.STD_FRAGMENT_ANALYSIS_TYPE_ID != null)
                {
                    BaseControlDropDownListAnalysisType.Text = analyte.STD_FRAGMENT_ANALYSIS_TYPE_ID.ToString();
                }
                BaseControlTextBoxCasNumber.Text = analyte.CAS_NUMBER;
                BaseControlTextBoxResult.Text = analyte.RESULT;
                BaseControlTextBoxComments.Text = analyte.COMMENTS;
            }
        }

        private void ResponseRedirect(string destination, string queryString)
        {
            try
            {
                string queryStringValue = string.Empty;
                if (queryString != null)
                {
                    queryStringValue = AntiXssEncoder.UrlEncode(queryString);
                }

                string destinationUrl = string.Concat(destination, queryStringValue);
                string currentHost = Request.Url.Host;
                if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
                {
                    //Response.Redirect(destinationUrl);
                    Server.Transfer(destinationUrl);
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError("Failure in to redirect to Export page: - DOD Fragment page.: " + ex.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            }
        }
    }
}
